<?php
session_start();

$valid_users = [
    'goblok' => password_hash('goblok', PASSWORD_DEFAULT),
];

if (isset($_SESSION['logged_in']) && $_SESSION['logged_in']) {
    header('Location: kezy.php');
    exit;
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';

    if (array_key_exists($username, $valid_users) && password_verify($password, $valid_users[$username])) {
        $_SESSION['logged_in'] = true;
        $_SESSION['username'] = $username; 
        header('Location: kezy.php');
        exit;
    } else {
        $error = "Username atau Password Salah!";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>LOGIN</title>
<link rel="icon" type="image/png" href="favicon.png">
<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">

<style>
  body {
    font-family: 'Poppins', sans-serif;
    /* Background Serasi dengan Panel */
    background: linear-gradient(rgba(0, 0, 0, 0.6), rgba(0, 0, 0, 0.8)), url('https://i.ibb.co.com/wF8tS32F/IMG-20260120-WA0191.jpg') no-repeat center center fixed;
    background-size: cover;
    margin: 0;
    padding: 0;
    display: flex;
    justify-content: center;
    align-items: center;
    height: 100vh;
    color: #fff;
  }

  /* Kotak Login Efek Kaca */
  .login-card {
    width: 100%;
    max-width: 400px;
    padding: 40px 30px;
    background: rgba(255, 255, 255, 0.05); /* Transparan */
    backdrop-filter: blur(15px); /* Efek Blur */
    -webkit-backdrop-filter: blur(15px);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 20px;
    box-shadow: 0 15px 35px rgba(0, 0, 0, 0.5);
  }

  .login-card h2 {
    text-align: center;
    margin-bottom: 30px;
    font-weight: 600;
    letter-spacing: 1px;
    text-transform: uppercase;
    color: #fff;
    text-shadow: 0 2px 10px rgba(0,0,0,0.5);
  }

  /* Styling Input Group agar menyatu */
  .input-group {
    background-color: rgba(0, 0, 0, 0.3);
    border-radius: 30px;
    border: 1px solid rgba(255, 255, 255, 0.2);
    margin-bottom: 20px;
    overflow: hidden;
    transition: all 0.3s;
  }

  .input-group:hover, .input-group:focus-within {
    border-color: #38ef7d;
    box-shadow: 0 0 10px rgba(56, 239, 125, 0.2);
  }

  .input-group-text {
    background: transparent;
    border: none;
    color: #bbb;
    padding-left: 20px;
  }

  .form-control {
    background: transparent !important;
    border: none !important;
    color: #fff !important;
    height: 50px;
    box-shadow: none !important;
    padding-left: 15px;
  }
  
  .form-control::placeholder {
    color: #aaa;
    font-size: 0.9rem;
  }

  /* Tombol Gradient Keren */
  .btn-login {
    background: linear-gradient(45deg, #11998e, #38ef7d);
    border: none;
    border-radius: 30px;
    padding: 12px;
    font-size: 16px;
    font-weight: bold;
    color: white;
    text-transform: uppercase;
    letter-spacing: 1px;
    width: 100%;
    margin-top: 10px;
    box-shadow: 0 4px 15px rgba(56, 239, 125, 0.4);
    transition: all 0.3s ease;
  }

  .btn-login:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 20px rgba(56, 239, 125, 0.6);
    color: #fff;
  }

  /* Pesan Error */
  .alert-custom {
    background: rgba(255, 75, 43, 0.2);
    border: 1px solid rgba(255, 75, 43, 0.5);
    color: #ff9999;
    font-size: 14px;
    text-align: center;
    border-radius: 10px;
    padding: 10px;
    margin-top: 20px;
  }
</style>
</head>
<body>

<div class="login-card">
  <h2><i class="fas fa-fingerprint mb-2" style="font-size: 40px; color: #38ef7d;"></i><br>Login</h2>
  
  <form method="POST" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" autocomplete="off">
    
    <div class="input-group">
      <div class="input-group-prepend">
        <span class="input-group-text"><i class="fas fa-user"></i></span>
      </div>
      <input type="text" class="form-control" id="username" name="username" placeholder="Username" required>
    </div>

    <div class="input-group">
      <div class="input-group-prepend">
        <span class="input-group-text"><i class="fas fa-lock"></i></span>
      </div>
      <input type="password" class="form-control" id="password" name="password" placeholder="Password" required>
    </div>

    <button type="submit" class="btn btn-login">Masuk Sekarang</button>

    <?php if (!empty($error)): ?>
      <div class="alert-custom">
        <i class="fas fa-exclamation-triangle mr-1"></i> <?php echo $error; ?>
      </div>
    <?php endif; ?>

  </form>
</div>

<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@1.16.0/dist/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
